// Original Ingot Box Author Unknown
// Scripted by Karmageddon
using Server.ContextMenus;
using Server.Gumps;
using Server.Mobiles;
using Server.Network;
using Server.Prompts;
using System;
using System.Collections.Generic;

namespace Server.Items
{
    public class FishersKeg : BaseContainer
    {
        private SortedDictionary<int, int> m_AcquiredItems;

        public bool HasItem(int dyeID)
        {
            if (m_AcquiredItems != null && m_AcquiredItems.ContainsKey(dyeID))
                return true;

            return false;
        }

        public void AcquireDye(int dyeID, int uses)
        {
            if (m_AcquiredItems == null)
                m_AcquiredItems = new SortedDictionary<int, int>();

            if (HasItem(dyeID))
                m_AcquiredItems[dyeID] += uses;
            else
                m_AcquiredItems[dyeID] = uses;
        }

        // 		public void ResetDyes()
        // 		{
        // 			m_AcquiredItems = null;
        // 		}

        public int KnownItems
        {
            get
            {
                if (m_AcquiredItems == null)
                    return 0;

                return m_AcquiredItems.Count;
            }
        }

        public int SumBigFishWeight
        {
            get
            {
                if (m_AcquiredItems == null)
                    return 0;

                int val = 0;

                foreach (KeyValuePair<int, int> kvp in m_AcquiredItems)
                {
                    val += (kvp.Key * kvp.Value);
                }

                return val;
            }
        }

        public int SumBigFish
        {
            get
            {
                if (m_AcquiredItems == null)
                    return 0;

                int val = 0;

                foreach (KeyValuePair<int, int> kvp in m_AcquiredItems)
                {
                    val += kvp.Value;
                }

                return val;
            }
        }

        public SortedDictionary<int, int> AcquiredItems
        {
            get
            {
                if (m_AcquiredItems == null)
                    return null;

                return m_AcquiredItems;
            }

            set { m_AcquiredItems = value; }
        }

        private int m_FishAlbinoAngelfish;
        private int m_FishAngelfish;
        private int m_FishBladePlant;
        private int m_FishBlueCory;
        private int m_FishBrineShrimp;
        private int m_FishBritainiaCrownFish;
        private int m_FishClownfish;
        private int m_FishFandancer;
        private int m_FishFishies;
        private int m_FishGoldenBroadtail;
        private int m_FishJellyfish;
        private int m_FishMinocBlue;
        private int m_FishNujelmHoney;
        private int m_FishRainbowMolly;
        private int m_FishShrimp;
        private int m_FishSmallmouthSuckerfish;
        private int m_FishSpeckledCrab;
        private int m_FishCoral;
        private int m_FishSpottedBucaneer;
        private int m_FishSeaHorse;
        private int m_FishSpottedPuffer;
        private int m_FishStripedSosarianSwill;
        private int m_FishVesperReefTiger;
        private int m_FishBones;
        private int m_SpecialFishingNet;
        private int m_Fish;
        private int m_FabledFishingNet;
        private int m_SailorBones;

        [CommandProperty(AccessLevel.GameMaster)]
        public int FishSeaHorse { get { return m_FishSeaHorse; } set { m_FishSeaHorse = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishAlbinoAngelfish { get { return m_FishAlbinoAngelfish; } set { m_FishAlbinoAngelfish = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishAngelfish { get { return m_FishAngelfish; } set { m_FishAngelfish = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishBladePlant { get { return m_FishBladePlant; } set { m_FishBladePlant = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishBlueCory { get { return m_FishBlueCory; } set { m_FishBlueCory = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishBrineShrimp { get { return m_FishBrineShrimp; } set { m_FishBrineShrimp = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishBritainiaCrownFish { get { return m_FishBritainiaCrownFish; } set { m_FishBritainiaCrownFish = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishClownfish { get { return m_FishClownfish; } set { m_FishClownfish = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishFandancer { get { return m_FishFandancer; } set { m_FishFandancer = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishFishies { get { return m_FishFishies; } set { m_FishFishies = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishGoldenBroadtail { get { return m_FishGoldenBroadtail; } set { m_FishGoldenBroadtail = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishJellyfish { get { return m_FishJellyfish; } set { m_FishJellyfish = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishMinocBlue { get { return m_FishMinocBlue; } set { m_FishMinocBlue = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishNujelmHoney { get { return m_FishNujelmHoney; } set { m_FishNujelmHoney = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishRainbowMolly { get { return m_FishRainbowMolly; } set { m_FishRainbowMolly = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishShrimp { get { return m_FishShrimp; } set { m_FishShrimp = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishSmallmouthSuckerfish { get { return m_FishSmallmouthSuckerfish; } set { m_FishSmallmouthSuckerfish = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishSpeckledCrab { get { return m_FishSpeckledCrab; } set { m_FishSpeckledCrab = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishCoral { get { return m_FishCoral; } set { m_FishCoral = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishSpottedBucaneer { get { return m_FishSpottedBucaneer; } set { m_FishSpottedBucaneer = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishSpottedPuffer { get { return m_FishSpottedPuffer; } set { m_FishSpottedPuffer = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishStripedSosarianSwill { get { return m_FishStripedSosarianSwill; } set { m_FishStripedSosarianSwill = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishVesperReefTiger { get { return m_FishVesperReefTiger; } set { m_FishVesperReefTiger = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FishBones { get { return m_FishBones; } set { m_FishBones = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int SpecialFishingNet { get { return m_SpecialFishingNet; } set { m_SpecialFishingNet = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int Fish { get { return m_Fish; } set { m_Fish = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int FabledFishingNet { get { return m_FabledFishingNet; } set { m_FabledFishingNet = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int SailorBones { get { return m_SailorBones; } set { m_SailorBones = value; } }

        public override bool DisplaysContent { get { return false; } }
        public override bool DisplayWeight { get { return true; } }

        [Constructable]
        public FishersKeg()
        : base(9431)
        {
            Movable = true;
            Weight = 20.0;
            Hue = 1366;
            Name = "Rybarsky sak";
            LootType = LootType.Blessed;

            /* 			if(m_AcquiredItems == null)
                            m_AcquiredItems = new SortedDictionary<int, int>();

                        for (int i = 8; i < 201; i++)
                        {
                            m_AcquiredItems[i] = Utility.RandomMinMax(1, 55);
                        }
             */
        }

        /* 		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);

			if (BlessedFor != null)
				list.Add(1072304, m_Owner.RawName); // owned by ~1_NAME~
		}
 */

        public class OpenGumpEntry : ContextMenuEntry
        {
            private Mobile m_From;
            private FishersKeg i_Cont;

            public OpenGumpEntry(Mobile from, FishersKeg cont) : base(6122)
            {
                m_From = from;
                i_Cont = cont;
            }

            public override void OnClick()
            {
                if (m_From is PlayerMobile && m_From.AccessLevel > AccessLevel.Player)
                {
                    m_From.SendGump(new FishersKegGump((PlayerMobile)m_From, i_Cont));
                }
            }
        }

        public override void GetContextMenuEntries(Mobile from, List<ContextMenuEntry> list)
        {
            if (from.AccessLevel > AccessLevel.Player)
            {
                list.Add(new OpenGumpEntry(from, this));
            }

            base.GetContextMenuEntries(from, list);
        }


        public override void OnDoubleClick(Mobile from)
        {
            if (from.AccessLevel > AccessLevel.Player)
            {
                from.SendGump(new FishersKegGump((PlayerMobile)from, this));
                return;
            }

            if (BlessedFor == null)
            {
                if (!IsChildOf(from.Backpack))
                {
                    from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
                    return;
                }
                else
                    BlessedFor = from;

                InvalidateProperties();
            }

            if (!from.InRange(GetWorldLocation(), 2))
                from.LocalOverheadMessage(Network.MessageType.Regular, 0x3B2, 1019045); // I can't reach that.
            else if (BlessedFor == from && from is PlayerMobile)
            {
                from.SendGump(new FishersKegGump((PlayerMobile)from, this));
            }
            else
                from.SendMessage("Toto neni tvuj rybarsky sak!"); //You are not the owner.
        }

        public override bool OnDragDrop(Mobile from, Item curItem)
        {
            if (from.HasGump(typeof(BigFishGump)))
            {
                from.CloseGump(typeof(BigFishGump));
            }

            if (from.HasGump(typeof(FishersKegGump)))
            {
                from.CloseGump(typeof(FishersKegGump));
            }

            if (BlessedFor != from)
            {
                from.SendMessage("Toto neni tvuj rybarsky sak!"); //You are not the owner.
                return false;
            }

            //start drag drop
            if (curItem is FishSeaHorse)
            {
                if (FishSeaHorse >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishSeaHorse += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishAlbinoAngelfish)
            {
                if (FishAlbinoAngelfish >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishAlbinoAngelfish += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishAngelfish)
            {
                if (FishAngelfish >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishAngelfish += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishBladePlant)
            {
                if (FishBladePlant >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishBladePlant += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishBlueCory)
            {
                if (FishBlueCory >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishBlueCory += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishBrineShrimp)
            {
                if (FishBrineShrimp >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishBrineShrimp += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishBritainiaCrownFish)
            {
                if (FishBritainiaCrownFish >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishBritainiaCrownFish += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishClownfish)
            {
                if (FishClownfish >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishClownfish += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishFandancer)
            {
                if (FishFandancer >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishFandancer += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishFishies)
            {
                if (FishFishies >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishFishies += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishGoldenBroadtail)
            {
                if (FishGoldenBroadtail >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishGoldenBroadtail += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishJellyfish)
            {
                if (FishJellyfish >= 999999)
                    from.SendMessage("Vice techto predmetu se jiz do saku nevejde.");
                else
                {
                    FishJellyfish += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishMinocBlue)
            {
                if (FishMinocBlue >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishMinocBlue += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishNujelmHoney)
            {
                if (FishNujelmHoney >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishNujelmHoney += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishRainbowMolly)
            {
                if (FishRainbowMolly >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishRainbowMolly += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishShrimp)
            {
                if (FishShrimp >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishShrimp += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishSmallmouthSuckerfish)
            {
                if (FishSmallmouthSuckerfish >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishSmallmouthSuckerfish += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishSpeckledCrab)
            {
                if (FishSpeckledCrab >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishSpeckledCrab += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishCoral)
            {
                if (FishCoral >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishCoral += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishSpottedBucaneer)
            {
                if (FishSpottedBucaneer >= 999999)
                    from.SendMessage("Vice prazdnych lahvi se do saku nevejde.");
                else
                {
                    FishSpottedBucaneer += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishSpottedPuffer)
            {
                if (FishSpottedPuffer >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishSpottedPuffer += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishStripedSosarianSwill)
            {
                if (FishStripedSosarianSwill >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishStripedSosarianSwill += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishVesperReefTiger)
            {
                if (FishVesperReefTiger >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishVesperReefTiger += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FishBones)
            {
                if (FishBones >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    FishBones += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is SpecialFishingNet && !(curItem is FabledFishingNet))
            {
                if (SpecialFishingNet >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    SpecialFishingNet += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is Fish)
            {
                if (Fish >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    Fish += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is FabledFishingNet)
            {
                if (m_FabledFishingNet >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else
                {
                    m_FabledFishingNet += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is SailorBones)
            {
                if (m_SailorBones >= 999999)
                    from.SendMessage("Vice tohoto predmetu se jiz do saku nevejde.");
                else if (((SailorBones)curItem).Items.Count > 0)
                    from.SendMessage("Kostra namornika musi byt prazdna");
                else
                {
                    m_SailorBones += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            if (curItem is BigFish)
            {
                if (((BigFish)curItem).Fisher != from)
                    from.SendMessage("Tuto rybu jsi neulovil/a ty");
                else
                {
                    AcquireDye((int)curItem.Weight, 1);
                    curItem.Delete();
                    from.SendMessage("predmet byl vlozen.");
                    return true;
                }
            }

            return false;
            //end drag drop
        }

        public FishersKeg(Serial serial)
        : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)1); // version

            if (m_AcquiredItems == null)
            {
                writer.Write((int)0);
            }
            else
            {
                writer.Write(m_AcquiredItems.Count);

                foreach (KeyValuePair<int, int> kvp in m_AcquiredItems)
                {
                    writer.Write(kvp.Key);
                    writer.Write(kvp.Value);
                }
            }

            writer.Write((int)m_FabledFishingNet);
            writer.Write((int)m_SailorBones);

            writer.Write((int)m_FishAlbinoAngelfish);
            writer.Write((int)m_FishAngelfish);
            writer.Write((int)m_FishBladePlant);
            writer.Write((int)m_FishBlueCory);
            writer.Write((int)m_FishBrineShrimp);
            writer.Write((int)m_FishBritainiaCrownFish);
            writer.Write((int)m_FishClownfish);
            writer.Write((int)m_FishFishies);
            writer.Write((int)m_FishGoldenBroadtail);
            writer.Write((int)m_FishJellyfish);
            writer.Write((int)m_FishMinocBlue);
            writer.Write((int)m_FishNujelmHoney);
            writer.Write((int)m_FishRainbowMolly);
            writer.Write((int)m_FishShrimp);
            writer.Write((int)m_FishSmallmouthSuckerfish);
            writer.Write((int)m_FishSpeckledCrab);
            writer.Write((int)m_FishCoral);
            writer.Write((int)m_FishSpottedBucaneer);
            writer.Write((int)m_FishSeaHorse);
            writer.Write((int)m_FishFandancer);
            writer.Write((int)m_FishSpottedPuffer);
            writer.Write((int)m_FishStripedSosarianSwill);
            writer.Write((int)m_FishVesperReefTiger);
            writer.Write((int)m_FishBones);
            writer.Write((int)m_SpecialFishingNet);
            writer.Write((int)m_Fish);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();

            switch (version)
            {
                case 1:
                    {
                        int dyesCount = reader.ReadInt();

                        if (dyesCount > 0)
                        {
                            m_AcquiredItems = new SortedDictionary<int, int>();

                            for (int i = 0; i < dyesCount; i++)
                            {
                                int r = reader.ReadInt();
                                int ri = reader.ReadInt();
                                m_AcquiredItems.Add(r, ri);
                            }
                        }

                        m_FabledFishingNet = reader.ReadInt();
                        m_SailorBones = reader.ReadInt();
                        goto case 0;
                    }

                case 0:
                    {
                        m_FishAlbinoAngelfish = reader.ReadInt();
                        m_FishAngelfish = reader.ReadInt();
                        m_FishBladePlant = reader.ReadInt();
                        m_FishBlueCory = reader.ReadInt();
                        m_FishBrineShrimp = reader.ReadInt();
                        m_FishBritainiaCrownFish = reader.ReadInt();
                        m_FishClownfish = reader.ReadInt();
                        m_FishFishies = reader.ReadInt();
                        m_FishGoldenBroadtail = reader.ReadInt();
                        m_FishJellyfish = reader.ReadInt();
                        m_FishMinocBlue = reader.ReadInt();
                        m_FishNujelmHoney = reader.ReadInt();
                        m_FishRainbowMolly = reader.ReadInt();
                        m_FishShrimp = reader.ReadInt();
                        m_FishSmallmouthSuckerfish = reader.ReadInt();
                        m_FishSpeckledCrab = reader.ReadInt();
                        m_FishCoral = reader.ReadInt();
                        m_FishSpottedBucaneer = reader.ReadInt();
                        m_FishSeaHorse = reader.ReadInt();
                        m_FishFandancer = reader.ReadInt();
                        m_FishSpottedPuffer = reader.ReadInt();
                        m_FishStripedSosarianSwill = reader.ReadInt();
                        m_FishVesperReefTiger = reader.ReadInt();
                        m_FishBones = reader.ReadInt();
                        m_SpecialFishingNet = reader.ReadInt();
                        m_Fish = reader.ReadInt();
                        break;
                    }
            }
        }

        public class BigFishGump : Gump
        {
            private static readonly int m_Fields = 30;
            private static readonly int m_HueTit = 0;
            private static readonly int m_HueEnt = 0;
            private static readonly int m_DeltaBut = 2;
            private static readonly int m_FieldsDist = 36;

            private FishersKeg m_Box;
            private List<int> m_Dyes;
            private int m_Page;

            public BigFishGump(FishersKeg box) : this(box, null, 1)
            {
            }

            public BigFishGump(FishersKeg box, int page) : this(box, null, page)
            {
            }

            public BigFishGump(FishersKeg box, List<int> dyes, int page) : base(50, 50)
            {
                Closable = false;
                Disposable = true;
                Dragable = true;
                Resizable = false;

                m_Box = box;
                m_Dyes = dyes;
                m_Page = page;

                if (m_Dyes == null)
                    m_Dyes = new List<int>(m_Box.AcquiredItems.Keys);

                Initialize();
            }

            public void Initialize()
            {
                if (m_Box.KnownItems < 1)
                    return;

                AddPage(0);

                AddBackground(0, 0, 375, 455, 9200);

                AddImageTiled(10, 10, 355, 25, 9354);
                AddImageTiled(10, 45, 355, 370, 9354);
                AddImageTiled(40, 425, 325, 20, 9354);

                AddButton(10, 425, 4017, 4018, 0, GumpButtonType.Reply, 0);
                AddHtmlLocalized(45, 425, 75, 20, 1011012, m_HueTit, false, false); // CANCEL

                // 				AddAlphaRegion(10, 10, 355, 415);
                // 				AddAlphaRegion(40, 425, 325, 20);
                AddLabelCropped(14, 12, 355, 25, m_HueTit, String.Format("BIG FISH ({0} ryb / {1} stones)", m_Box.SumBigFish, m_Box.SumBigFishWeight));
                // 	            AddHtmlLocalized( 14, 12, 355, 25, 1049753, m_HueTit, false, false ); // Dye Tubs

                if (m_Page > 1)
                    AddButton(325, 427, 5603, 5607, 2, GumpButtonType.Reply, 0); // Previous page

                if (m_Page < Math.Ceiling(m_Dyes.Count / (double)m_Fields))
                    AddButton(345, 427, 5601, 5605, 3, GumpButtonType.Reply, 0); // Next Page

                int IndMax = (m_Page * m_Fields) - 1;
                int IndMin = (m_Page * m_Fields) - m_Fields;
                int IndTemp = 0;
                int RightTemp = 0;

                for (int i = 0; i < m_Dyes.Count; i++)
                {
                    if (i >= IndMin && i <= IndMax)
                    {
                        AddLabelCropped(32 + RightTemp, 52 + (IndTemp * m_FieldsDist), 225, 20, m_HueTit, String.Format("{0} stones ({1})", m_Dyes[i], (m_Box.HasItem(m_Dyes[i])) ? m_Box.AcquiredItems[m_Dyes[i]] : 0));
                        AddButton(15 + RightTemp, 52 + m_DeltaBut + (IndTemp * m_FieldsDist), 1209, 1210, i + 10, GumpButtonType.Reply, 0);
                        // AddItem(100 + RightTemp, 50 + (IndTemp * m_FieldsDist), 4011, m_Dyes[i]);
                        IndTemp++;

                        if (IndTemp == 10 && RightTemp == 0)
                        {
                            IndTemp = 0;
                            RightTemp = 120;
                        }
                        else if (IndTemp == 10 && RightTemp == 120)
                        {
                            IndTemp = 0;
                            RightTemp = 235;
                        }
                    }
                }
            }

            public override void OnResponse(NetState sender, RelayInfo info)
            {
                Mobile from = sender.Mobile;

                if (info.ButtonID == 0)
                {
                    from.SendGump(new FishersKegGump((PlayerMobile)from, m_Box));
                }
                else if (info.ButtonID == 2) // Previous page
                {
                    m_Page--;
                    from.SendGump(new BigFishGump(m_Box, m_Dyes, m_Page));
                }
                else if (info.ButtonID == 3) // Next Page
                {
                    m_Page++;
                    from.SendGump(new BigFishGump(m_Box, m_Dyes, m_Page));
                }
                else
                {
                    int id = m_Dyes[info.ButtonID - 10];

                    if (m_Box == null || !m_Box.HasItem(id))
                        return;

                    if (m_Box.AcquiredItems[id] > 0)
                    {
                        BigFish fish = new BigFish();
                        fish.Weight = id;
                        fish.Fisher = from;

                        from.AddToBackpack(fish);
                        m_Box.AcquiredItems[id]--;

                        if (m_Box.AcquiredItems[id] == 0)
                            m_Box.AcquiredItems.Remove(id);
                    }
                    else
                    {
                        from.SendMessage("Tohle v truhle neni");
                    }

                    from.SendGump(new BigFishGump(m_Box, m_Page));
                    m_Box.InvalidateProperties();
                }
            }
        }

        public class FishersKegGump : Gump
        {
            private PlayerMobile m_From;
            private FishersKeg m_Box;

            public FishersKegGump(PlayerMobile from, FishersKeg box)
            : base(25, 25)
            {
                m_From = from;
                m_Box = box;

                m_From.CloseGump(typeof(FishersKegGump));

                this.Closable = true;
                this.Disposable = true;
                this.Dragable = true;
                this.Resizable = false;

                AddPage(0);
                AddBackground(0, 0, 528, 382, 9200);
                AddLabel(150, 9, 3, String.Format("Rybarsky sak (Majitel: {0})", (m_Box.BlessedFor != null) ? m_Box.BlessedFor.RawName : "Neznamy"));
                AddButton(371, 265, 4005, 4006, (int)Buttons.Fish, GumpButtonType.Reply, 0);
                AddLabel(461, 268, 0, box.Fish.ToString());
                AddItem(413, 257, 2508);
                AddButton(371, 302, 4005, 4006, (int)Buttons.SpecialFishingNet, GumpButtonType.Reply, 0);
                AddItem(413, 292, 3530, 2208);
                AddLabel(461, 306, 0, box.SpecialFishingNet.ToString());
                AddButton(13, 106, 4005, 4006, (int)Buttons.FishAlbinoAngelfish, GumpButtonType.Reply, 0);
                AddItem(51, 107, 15108);
                AddLabel(97, 109, 0, box.FishAlbinoAngelfish.ToString());
                AddButton(13, 139, 4005, 4006, (int)Buttons.FishAngelfish, GumpButtonType.Reply, 0);
                AddItem(48, 137, 15115);
                AddLabel(97, 141, 0, box.FishAngelfish.ToString());
                AddItem(48, 167, 3219);
                AddButton(13, 171, 4005, 4006, (int)Buttons.FishBladePlant, GumpButtonType.Reply, 0);
                AddLabel(97, 172, 0, box.FishBladePlant.ToString());
                AddItem(48, 204, 15111);
                AddButton(13, 203, 4005, 4006, (int)Buttons.FishBlueCory, GumpButtonType.Reply, 0);
                AddLabel(97, 204, 0, box.FishBlueCory.ToString());
                AddButton(13, 236, 4005, 4006, (int)Buttons.FishBrineShrimp, GumpButtonType.Reply, 0);
                AddItem(48, 235, 15121);
                AddLabel(97, 236, 0, box.FishBrineShrimp.ToString());
                AddButton(13, 268, 4005, 4006, (int)Buttons.FishBritainiaCrownFish, GumpButtonType.Reply, 0);
                AddItem(48, 261, 15103);
                AddLabel(97, 267, 0, box.FishBritainiaCrownFish.ToString());
                AddButton(13, 300, 4005, 4006, (int)Buttons.FishClownfish, GumpButtonType.Reply, 0);
                AddItem(48, 299, 15105);
                AddLabel(97, 299, 0, box.FishClownfish.ToString());
                AddButton(371, 228, 4005, 4006, (int)Buttons.FishFandancer, GumpButtonType.Reply, 0);
                AddItem(413, 223, 15101);
                AddLabel(461, 231, 0, box.FishFandancer.ToString());
                AddButton(13, 42, 4005, 4006, (int)Buttons.FishFishies, GumpButtonType.Reply, 0);
                AddItem(48, 44, 3543);
                AddLabel(97, 46, 0, box.FishFishies.ToString());
                AddButton(178, 40, 4005, 4006, (int)Buttons.FishGoldenBroadtail, GumpButtonType.Reply, 0);
                AddItem(215, 37, 15107);
                AddLabel(272, 44, 0, box.FishGoldenBroadtail.ToString());
                AddButton(178, 73, 4005, 4006, (int)Buttons.FishJellyfish, GumpButtonType.Reply, 0);
                AddItem(215, 64, 15118);
                AddLabel(272, 77, 0, box.FishJellyfish.ToString());
                AddButton(178, 106, 4005, 4006, (int)Buttons.FishMinocBlue, GumpButtonType.Reply, 0);
                AddItem(221, 114, 15102);
                AddLabel(272, 109, 0, box.FishMinocBlue.ToString());
                AddButton(178, 139, 4005, 4006, (int)Buttons.FishNujelmHoney, GumpButtonType.Reply, 0);
                AddItem(223, 134, 15110);
                AddLabel(272, 142, 0, box.FishNujelmHoney.ToString());
                AddButton(178, 172, 4005, 4006, (int)Buttons.FishRainbowMolly, GumpButtonType.Reply, 0);
                AddItem(215, 172, 15106);
                AddLabel(272, 174, 0, box.FishRainbowMolly.ToString());
                AddButton(178, 205, 4005, 4006, (int)Buttons.FishShrimp, GumpButtonType.Reply, 0);
                AddItem(215, 204, 15124);
                AddLabel(272, 207, 0, box.FishShrimp.ToString());
                AddButton(178, 238, 4005, 4006, (int)Buttons.FishSmallmouthSuckerfish, GumpButtonType.Reply, 0);
                AddItem(215, 237, 15104);
                AddLabel(272, 240, 0, box.FishSmallmouthSuckerfish.ToString());
                AddButton(178, 271, 4005, 4006, (int)Buttons.FishSpeckledCrab, GumpButtonType.Reply, 0);
                AddItem(212, 258, 15100);
                AddLabel(272, 272, 0, box.FishSpeckledCrab.ToString());
                AddButton(178, 304, 4005, 4006, (int)Buttons.FishCoral, GumpButtonType.Reply, 0);
                AddItem(212, 298, 15098);
                AddLabel(272, 305, 0, box.FishCoral.ToString());
                AddButton(13, 74, 4005, 4006, (int)Buttons.FishSpottedBucaneer, GumpButtonType.Reply, 0);
                AddItem(48, 74, 15113);
                AddLabel(97, 78, 0, box.FishSpottedBucaneer.ToString());
                AddButton(371, 42, 4005, 4006, (int)Buttons.FishSeaHorse, GumpButtonType.Reply, 0);
                AddItem(413, 38, 15120);
                AddLabel(461, 43, 0, box.FishSeaHorse.ToString());
                AddButton(371, 79, 4005, 4006, (int)Buttons.FishSpottedPuffer, GumpButtonType.Reply, 0);
                AddItem(413, 78, 15109);
                AddLabel(461, 81, 0, box.FishSpottedPuffer.ToString());
                AddButton(371, 116, 4005, 4006, (int)Buttons.FishStripedSosarianSwill, GumpButtonType.Reply, 0);
                AddItem(413, 114, 15114);
                AddLabel(461, 118, 0, box.FishStripedSosarianSwill.ToString());
                AddButton(371, 153, 4005, 4006, (int)Buttons.FishVesperReefTiger, GumpButtonType.Reply, 0);
                AddItem(413, 154, 15112);
                AddLabel(461, 155, 0, box.FishVesperReefTiger.ToString());
                AddButton(371, 191, 4005, 4006, (int)Buttons.FishBones, GumpButtonType.Reply, 0);
                AddItem(413, 189, 15116);
                AddLabel(461, 191, 0, box.FishBones.ToString());

                //Spodni rada
                AddButton(13, 342, 4005, 4006, (int)Buttons.BigFish, GumpButtonType.Reply, 0);
                AddItem(48, 332, 0x09CC, 0x847);
                AddLabel(97, 342, 0, box.SumBigFish.ToString());

                AddButton(178, 342, 4005, 4006, (int)Buttons.SailorBones, GumpButtonType.Reply, 0);
                AddItem(212, 332, 3791);
                AddLabel(272, 342, 0, box.SailorBones.ToString());

                AddButton(371, 342, 4005, 4006, (int)Buttons.FabledFishingNet, GumpButtonType.Reply, 0);
                AddItem(413, 332, 3530, 1153);
                AddLabel(461, 342, 0, box.FabledFishingNet.ToString());
            }

            public enum Buttons
            {
                Close,
                BigFish,
                FabledFishingNet,
                SailorBones,
                Fish,
                SpecialFishingNet,
                FishAlbinoAngelfish,
                FishAngelfish,
                FishBladePlant,
                FishBlueCory,
                FishBrineShrimp,
                FishBritainiaCrownFish,
                FishClownfish,
                FishFandancer,
                FishFishies,
                FishGoldenBroadtail,
                FishJellyfish,
                FishMinocBlue,
                FishNujelmHoney,
                FishRainbowMolly,
                FishShrimp,
                FishSmallmouthSuckerfish,
                FishSpeckledCrab,
                FishCoral,
                FishSpottedBucaneer,
                FishSeaHorse,
                FishSpottedPuffer,
                FishStripedSosarianSwill,
                FishVesperReefTiger,
                FishBones,
            }

            public override void OnResponse(NetState sender, RelayInfo info)
            {
                if (m_Box.Deleted || (sender.Mobile.AccessLevel < AccessLevel.GameMaster && (sender.Mobile != m_From || m_Box.BlessedFor != m_From)))
                    return;

                if (info.ButtonID == (int)Buttons.Close)
                {
                }

                if (info.ButtonID == (int)Buttons.FishBlueCory)
                {
                    if (m_Box.FishBlueCory > 0)
                    {
                        m_From.AddToBackpack(new FishBlueCory());                   //Sends all stored Granites of whichever type to players backpack
                        m_Box.FishBlueCory = m_Box.FishBlueCory - 1;                                                //Sets the count in the key back to 0
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));                 //Resets the gump with the new info
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishFishies)
                {
                    if (m_Box.FishFishies > 0)
                    {
                        m_From.AddToBackpack(new FishFishies());
                        m_Box.FishFishies = m_Box.FishFishies - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishAlbinoAngelfish)
                {
                    if (m_Box.FishAlbinoAngelfish > 0)
                    {
                        m_From.AddToBackpack(new FishAlbinoAngelfish());
                        m_Box.FishAlbinoAngelfish = m_Box.FishAlbinoAngelfish - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishBrineShrimp)
                {
                    if (m_Box.FishBrineShrimp > 0)
                    {
                        m_From.AddToBackpack(new FishBrineShrimp());
                        m_Box.FishBrineShrimp = m_Box.FishBrineShrimp - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishBritainiaCrownFish)
                {
                    if (m_Box.FishBritainiaCrownFish > 0)
                    {
                        m_From.AddToBackpack(new FishBritainiaCrownFish());
                        m_Box.FishBritainiaCrownFish = m_Box.FishBritainiaCrownFish - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishClownfish)
                {
                    if (m_Box.FishClownfish > 0)
                    {
                        m_From.AddToBackpack(new FishClownfish());
                        m_Box.FishClownfish = m_Box.FishClownfish - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishGoldenBroadtail)
                {
                    if (m_Box.FishGoldenBroadtail > 0)
                    {
                        m_From.AddToBackpack(new FishGoldenBroadtail());
                        m_Box.FishGoldenBroadtail = m_Box.FishGoldenBroadtail - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishBladePlant)
                {
                    if (m_Box.FishBladePlant > 0)
                    {
                        m_From.AddToBackpack(new FishBladePlant());
                        m_Box.FishBladePlant = m_Box.FishBladePlant - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishAngelfish)
                {
                    if (m_Box.FishAngelfish > 0)
                    {
                        m_From.AddToBackpack(new FishAngelfish());
                        m_Box.FishAngelfish = m_Box.FishAngelfish - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishMinocBlue)
                {
                    if (m_Box.FishMinocBlue > 0)
                    {
                        m_From.AddToBackpack(new FishMinocBlue());
                        m_Box.FishMinocBlue = m_Box.FishMinocBlue - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishNujelmHoney)
                {
                    if (m_Box.FishNujelmHoney > 0)
                    {
                        m_From.AddToBackpack(new FishNujelmHoney());
                        m_Box.FishNujelmHoney = m_Box.FishNujelmHoney - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishRainbowMolly)
                {
                    if (m_Box.FishRainbowMolly > 0)
                    {
                        m_From.AddToBackpack(new FishRainbowMolly());
                        m_Box.FishRainbowMolly = m_Box.FishRainbowMolly - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishShrimp)
                {
                    if (m_Box.FishShrimp > 0)
                    {
                        m_From.AddToBackpack(new FishShrimp());
                        m_Box.FishShrimp = m_Box.FishShrimp - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishSmallmouthSuckerfish)
                {
                    if (m_Box.FishSmallmouthSuckerfish > 0)
                    {
                        m_From.AddToBackpack(new FishSmallmouthSuckerfish());
                        m_Box.FishSmallmouthSuckerfish = m_Box.FishSmallmouthSuckerfish - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishSpeckledCrab)
                {
                    if (m_Box.FishSpeckledCrab > 0)
                    {
                        m_From.AddToBackpack(new FishSpeckledCrab());
                        m_Box.FishSpeckledCrab = m_Box.FishSpeckledCrab - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishJellyfish)
                {
                    if (m_Box.FishJellyfish > 0)
                    {
                        m_From.AddToBackpack(new FishJellyfish());
                        m_Box.FishJellyfish = m_Box.FishJellyfish - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishCoral)
                {
                    if (m_Box.FishCoral > 0)
                    {
                        m_From.AddToBackpack(new FishCoral());
                        m_Box.FishCoral = m_Box.FishCoral - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishSpottedBucaneer)
                {
                    if (m_Box.FishSpottedBucaneer > 0)
                    {
                        m_From.AddToBackpack(new FishSpottedBucaneer());
                        m_Box.FishSpottedBucaneer = m_Box.FishSpottedBucaneer - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishFandancer)
                {
                    if (m_Box.FishFandancer > 0)
                    {
                        m_From.AddToBackpack(new FishFandancer());
                        m_Box.FishFandancer = m_Box.FishFandancer - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishBones)
                {
                    if (m_Box.FishBones > 0)
                    {
                        m_From.SendMessage(0x55C, "Kolik Fish Bones chces vybrat?");
                        m_From.Prompt = new RemovalPrompt(m_From, m_Box, (int)info.ButtonID);
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishVesperReefTiger)
                {
                    if (m_Box.FishVesperReefTiger > 0)
                    {
                        m_From.AddToBackpack(new FishVesperReefTiger());
                        m_Box.FishVesperReefTiger = m_Box.FishVesperReefTiger - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishSpottedPuffer)
                {
                    if (m_Box.FishSpottedPuffer > 0)
                    {
                        m_From.AddToBackpack(new FishSpottedPuffer());
                        m_Box.FishSpottedPuffer = m_Box.FishSpottedPuffer - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishStripedSosarianSwill)
                {
                    if (m_Box.FishStripedSosarianSwill > 0)
                    {
                        m_From.AddToBackpack(new FishStripedSosarianSwill());
                        m_Box.FishStripedSosarianSwill = m_Box.FishStripedSosarianSwill - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FishSeaHorse)
                {
                    if (m_Box.FishSeaHorse > 0)
                    {
                        m_From.SendMessage(0x55C, "Kolik Sea Horse chces vybrat?");
                        m_From.Prompt = new RemovalPrompt(m_From, m_Box, (int)info.ButtonID);
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.SpecialFishingNet)
                {
                    if (m_Box.SpecialFishingNet > 0)
                    {
                        m_From.AddToBackpack(new SpecialFishingNet());
                        m_Box.SpecialFishingNet = m_Box.SpecialFishingNet - 1;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.Fish)
                {
                    if (m_Box.Fish > 0)
                    {
                        m_From.SendMessage(0x55C, "Kolik Fish chces vybrat?");
                        m_From.Prompt = new RemovalPrompt(m_From, m_Box, (int)info.ButtonID);
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.FabledFishingNet)
                {
                    if (m_Box.FabledFishingNet > 0)
                    {
                        m_From.AddToBackpack(new FabledFishingNet());
                        m_Box.FabledFishingNet--;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.SailorBones)
                {
                    if (m_Box.SailorBones > 0)
                    {
                        m_From.AddToBackpack(new SailorBones(0));
                        m_Box.SailorBones--;
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku jiz nemas zadny tento predmet!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }

                if (info.ButtonID == (int)Buttons.BigFish)
                {
                    if (m_Box.KnownItems > 0)
                    {
                        m_From.SendGump(new FishersKeg.BigFishGump(m_Box));
                    }
                    else
                    {
                        m_From.SendMessage("V saku nemas zadnou Big Fish!");
                        m_From.SendGump(new FishersKegGump(m_From, m_Box));
                    }
                }
            }

            public class RemovalPrompt : Prompt
            {
                private PlayerMobile m_Player;
                private FishersKeg m_Box;
                private int m_Buttons;
                public RemovalPrompt(PlayerMobile player, FishersKeg box, int button)
                {
                    m_Player = player;
                    m_Box = box;
                    m_Buttons = button;
                }

                public override void OnResponse(Mobile from, string text)
                {
                    if (m_Buttons == (int)Buttons.FishBones)
                    {
                        try
                        {
                            int amount = Convert.ToInt32(text);
                            if (amount > 0 && amount < 60001)
                            {
                                if ((m_Box.FishBones - amount) < 0)
                                {
                                    from.SendMessage(0x26, "Nemas tolik Fish Bones.");
                                }
                                else
                                {
                                    if (from.PlaceInBackpack(new FishBones(amount)))
                                    {
                                        m_Box.FishBones -= amount;
                                        from.CloseGump(typeof(FishersKegGump));
                                        from.SendGump(new FishersKegGump(m_Player, m_Box));
                                        from.SendMessage(0x55C, String.Format("Bylo vyjmuto {0} Fish Bones.", amount));
                                    }
                                    else
                                    {
                                        from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                        from.CloseGump(typeof(FishersKegGump));
                                        from.SendGump(new FishersKegGump(m_Player, m_Box));
                                    }
                                }
                            }
                            else
                            {
                                from.SendMessage(0x26, "Vyber v rozmezi 1 - 60 000");
                                from.CloseGump(typeof(FishersKegGump));
                                from.SendGump(new FishersKegGump(m_Player, m_Box));
                            }
                        }
                        catch
                        {
                            from.SendMessage(0x26, "Neplatny pozadavek");
                            from.CloseGump(typeof(FishersKegGump));
                            from.SendGump(new FishersKegGump(m_Player, m_Box));
                        }
                    }

                    if (m_Buttons == (int)Buttons.FishSeaHorse)
                    {
                        try
                        {
                            int amount = Convert.ToInt32(text);
                            if (amount > 0 && amount < 60001)
                            {
                                if ((m_Box.FishSeaHorse - amount) < 0)
                                {
                                    from.SendMessage(0x26, "Nemas tolik Sea Horse.");
                                }
                                else
                                {
                                    if (from.PlaceInBackpack(new FishSeaHorse(amount)))
                                    {
                                        m_Box.FishSeaHorse -= amount;
                                        from.CloseGump(typeof(FishersKegGump));
                                        from.SendGump(new FishersKegGump(m_Player, m_Box));
                                        from.SendMessage(0x55C, String.Format("Bylo vyjmuto {0} Sea Horse.", amount));
                                    }
                                    else
                                    {
                                        from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                        from.CloseGump(typeof(FishersKegGump));
                                        from.SendGump(new FishersKegGump(m_Player, m_Box));
                                    }
                                }
                            }
                            else
                            {
                                from.SendMessage(0x26, "Vyber v rozmezi 1 - 60 000");
                                from.CloseGump(typeof(FishersKegGump));
                                from.SendGump(new FishersKegGump(m_Player, m_Box));
                            }
                        }
                        catch
                        {
                            from.SendMessage(0x26, "Neplatny pozadavek");
                            from.CloseGump(typeof(FishersKegGump));
                            from.SendGump(new FishersKegGump(m_Player, m_Box));
                        }
                    }

                    if (m_Buttons == (int)Buttons.Fish)
                    {
                        try
                        {
                            int amount = Convert.ToInt32(text);
                            if (amount > 0 && amount < 60001)
                            {
                                if ((m_Box.Fish - amount) < 0)
                                {
                                    from.SendMessage(0x26, "Nemas tolik Fish.");
                                }
                                else
                                {
                                    if (from.PlaceInBackpack(new Fish(amount)))
                                    {
                                        m_Box.Fish -= amount;
                                        from.CloseGump(typeof(FishersKegGump));
                                        from.SendGump(new FishersKegGump(m_Player, m_Box));
                                        from.SendMessage(0x55C, String.Format("Bylo vyjmuto {0} Fish.", amount));
                                    }
                                    else
                                    {
                                        from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                        from.CloseGump(typeof(FishersKegGump));
                                        from.SendGump(new FishersKegGump(m_Player, m_Box));
                                    }
                                }
                            }
                            else
                            {
                                from.SendMessage(0x26, "Vyber v rozmezi 1 - 60 000");
                                from.CloseGump(typeof(FishersKegGump));
                                from.SendGump(new FishersKegGump(m_Player, m_Box));
                            }
                        }
                        catch
                        {
                            from.SendMessage(0x26, "Neplatny pozadavek");
                            from.CloseGump(typeof(FishersKegGump));
                            from.SendGump(new FishersKegGump(m_Player, m_Box));
                        }
                    }
                }
            }
        }
    }
}